#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

    [TestFixture]
    public class DAL_WorkLoad : BaseTest 
    {

		private DataTable _dtWorkloadProcess;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtWorkloadProcess = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadProcess WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);
				if (this._dtWorkloadProcess.Rows.Count == 0)
				{
					//Create WorkloadProcess records
					Guid randomProcessGuid =  DataCreator.GetRandomRecordGuid(TABLES.VbecsProcess.TableName, "");
					DataRow drProcess = UnitTestUtil.RunSQLGetDataRow("SELECT * FROM VbecsProcess WHERE VbecsProcessGuid = '" + randomProcessGuid.ToString() + "'");

					BOL.VbecsProcess tmpObj = new BOL.VbecsProcess(drProcess);

					DataRow drNewWorkload = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM WorkloadCache WHERE Code_Id > " + new Random().Next(1,199).ToString());
//					DataTable dtCPTS = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM CPTCache WHERE Code_Id = " + drWorkloadData[TABLES.CptCache.Code_Id].ToString());

					tmpObj.AddItem(tmpObj.GetNewWorkLoad(drNewWorkload[TABLES.WorkloadCache.Lmip].ToString()));
					tmpObj.SaveChanges(Common.UpdateFunction.UnitTests);

					this._dtWorkloadProcess = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadProcess WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}

				this.RefreshData = false;
			}

		}

        [Test]
		        public void GetAllVbecsProcesses_Pass()
        {
			DataTable dtTest = DAL.WorkLoad.GetAllVbecsProcesses();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsProcess.VbecsProcessGuid), TABLES.VbecsProcess.VbecsProcessGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsProcess.VbecsProcessId), TABLES.VbecsProcess.VbecsProcessId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsProcess.VbecsProcessName), TABLES.VbecsProcess.VbecsProcessName);
        }
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAllVbecsProcesses_Fail()
		{
		}

        [Test]
		        public void GetVbecsWorkLoadForDivision_Pass()
        {
            DataTable dtTest = DAL.WorkLoad.GetVbecsWorkLoadForDivision(UnitTestConfig.TestDivisionCode);

            Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(14, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WorkloadCode), TABLES.WorkloadProcess.WorkloadCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WorkloadProcessGuid), TABLES.WorkloadProcess.WorkloadProcessGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WeightMultiplier), TABLES.WorkloadProcess.WeightMultiplier);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.AssignedDate), TABLES.WorkloadProcess.AssignedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.UnAssignedDate), TABLES.WorkloadProcess.UnAssignedDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.DivisionCode), TABLES.WorkloadProcess.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.LastUpdateDate), TABLES.WorkloadProcess.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.LastUpdateUser), TABLES.WorkloadProcess.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.RecordStatusCode), TABLES.WorkloadProcess.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.RowVersion), TABLES.WorkloadProcess.RowVersion);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.VbecsProcessId), TABLES.WorkloadProcess.VbecsProcessId);
			//Don't forget about our 3 manmade columns added in the DAL.GetVbecsWorkLoadForDivision() method
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.Cost), ARTIFICIAL.Cost);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.Process), ARTIFICIAL.Process);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WorkloadProcedure), TABLES.WorkloadProcess.WorkloadProcedure);
        }

		[Test]
		public void GetVbecsWorkLoadForDivision_Fail()
		{
			DataTable dtTest = DAL.WorkLoad.GetVbecsWorkLoadForDivision("plop");

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

        [Test]
		        public void SaveWorkLoadChanges_Pass()
        {
			this.RefreshData = true;

			//Create an UPDATE
			DataTable dtSave = new DataTable();

			dtSave.Columns.Add(TABLES.WorkloadProcess.WorkloadCode, typeof(string));
			dtSave.Columns.Add(TABLES.WorkloadProcess.WorkloadProcessGuid, typeof(System.Guid));
			dtSave.Columns.Add(TABLES.WorkloadProcess.WorkloadProcedure, typeof(string));
			dtSave.Columns.Add(TABLES.WorkloadProcess.WeightMultiplier, typeof(int));
			dtSave.Columns.Add(TABLES.WorkloadProcess.DivisionCode, typeof(string));
			dtSave.Columns.Add(TABLES.WorkloadProcess.LastUpdateUser, typeof(string));
			dtSave.Columns.Add(TABLES.WorkloadProcess.RowVersion, typeof(byte[]));
			dtSave.Columns.Add(TABLES.WorkloadProcess.VbecsProcessId, typeof(int));
			dtSave.Columns.Add(TABLES.WorkloadProcess.RecordStatusCode, typeof(string));
			dtSave.Columns.Add(TABLES.WorkloadProcess.LastUpdateFunctionId, typeof(int));

			DataRow drUpd = dtSave.NewRow();
			drUpd[TABLES.WorkloadProcess.WorkloadCode] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.WorkloadCode];
			drUpd[TABLES.WorkloadProcess.WorkloadProcessGuid] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.WorkloadProcessGuid];
			drUpd[TABLES.WorkloadProcess.WeightMultiplier] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.WeightMultiplier];
			drUpd[TABLES.WorkloadProcess.DivisionCode] = this.TestDivisionCode;
			drUpd[TABLES.WorkloadProcess.LastUpdateUser] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.LastUpdateUser];
			drUpd[TABLES.WorkloadProcess.RowVersion] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.RowVersion];
			drUpd[TABLES.WorkloadProcess.VbecsProcessId] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.VbecsProcessId];
			drUpd[TABLES.WorkloadProcess.RecordStatusCode] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.RecordStatusCode];
			drUpd[TABLES.WorkloadProcess.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dtSave.Rows.Add(drUpd);
			dtSave.AcceptChanges();
			
			dtSave.Rows[0][TABLES.WorkloadProcess.LastUpdateUser] = Common.LogonUser.LogonUserName;

			//Create an INSERT
			DataRow drIns = dtSave.NewRow();
			drIns[TABLES.WorkloadProcess.WorkloadProcessGuid] = System.Guid.NewGuid();
			drIns[TABLES.WorkloadProcess.WorkloadCode] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.WorkloadCode];
			drIns[TABLES.WorkloadProcess.WorkloadProcedure] = System.DateTime.Now.ToString();
			drIns[TABLES.WorkloadProcess.WeightMultiplier] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.WeightMultiplier];
			drIns[TABLES.WorkloadProcess.DivisionCode] = this.TestDivisionCode;
			drIns[TABLES.WorkloadProcess.LastUpdateUser] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.LastUpdateUser];
			drIns[TABLES.WorkloadProcess.VbecsProcessId] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.VbecsProcessId];
			drIns[TABLES.WorkloadProcess.RecordStatusCode] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.RecordStatusCode];
			drIns[TABLES.WorkloadProcess.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dtSave.Rows.Add(drIns);
		
			DAL.WorkLoad.SaveWorkLoadChanges(dtSave, Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, true, "NoReturnCode");						
        }

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void SaveWorkLoadChanges_Fail()
		{
			DataTable dtSave = new DataTable();

			dtSave.Columns.Add(TABLES.WorkloadProcess.WorkloadCode, typeof(string));
			dtSave.Columns.Add(TABLES.WorkloadProcess.WorkloadProcessGuid, typeof(System.Guid));
			dtSave.Columns.Add(TABLES.WorkloadProcess.WeightMultiplier, typeof(int));
			dtSave.Columns.Add(TABLES.WorkloadProcess.DivisionCode, typeof(string));
			dtSave.Columns.Add(TABLES.WorkloadProcess.LastUpdateUser, typeof(string));
			dtSave.Columns.Add(TABLES.WorkloadProcess.RowVersion, typeof(byte[]));
			dtSave.Columns.Add(TABLES.WorkloadProcess.VbecsProcessId, typeof(int));
			dtSave.Columns.Add(TABLES.WorkloadProcess.RecordStatusCode, typeof(string));
			dtSave.Columns.Add(TABLES.WorkloadProcess.LastUpdateFunctionId, typeof(int));

			DataRow dr = dtSave.NewRow();
			dr[TABLES.WorkloadProcess.WorkloadCode] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.WorkloadCode];
			dr[TABLES.WorkloadProcess.WorkloadProcessGuid] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.WorkloadProcessGuid];
			dr[TABLES.WorkloadProcess.WeightMultiplier] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.WeightMultiplier];
			dr[TABLES.WorkloadProcess.DivisionCode] = this.TestDivisionCode;
			dr[TABLES.WorkloadProcess.LastUpdateUser] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.LastUpdateUser];
			dr[TABLES.WorkloadProcess.RowVersion] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.RowVersion];
			dr[TABLES.WorkloadProcess.VbecsProcessId] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.VbecsProcessId];
			dr[TABLES.WorkloadProcess.RecordStatusCode] = this._dtWorkloadProcess.Rows[0][TABLES.WorkloadProcess.RecordStatusCode];
			dr[TABLES.WorkloadProcess.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;

			dtSave.Rows.Add(dr);
			dtSave.AcceptChanges();		//Should cause an update to happen?		RowState.Modified
			
			dtSave.Rows[0][TABLES.WorkloadProcess.RowVersion] = new byte[8];

			DAL.WorkLoad.SaveWorkLoadChanges(dtSave, Common.UpdateFunction.UnitTests);
		}


		
		[Test]
		public void GetEmptyWorkloadProcessTableSchema_Pass()
		{
			DataTable dtTest = DAL.WorkLoad.GetEmptyWorkloadProcessTableSchema(true);

			Assert.AreEqual(TABLES.WorkloadProcess.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WorkloadProcessGuid), TABLES.WorkloadProcess.WorkloadProcessGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WeightMultiplier), TABLES.WorkloadProcess.WeightMultiplier);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.AssignedDate), TABLES.WorkloadProcess.AssignedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.UnAssignedDate), TABLES.WorkloadProcess.UnAssignedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.DivisionCode), TABLES.WorkloadProcess.DivisionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.RecordStatusCode), TABLES.WorkloadProcess.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.RowVersion), TABLES.WorkloadProcess.RowVersion);
		}

				
		[Test]
		public void GetEmptyWorkloadProcessTableSchema_Fail()
		{
			DataTable dtTest = DAL.WorkLoad.GetEmptyWorkloadProcessTableSchema(false);

			Assert.AreEqual(TABLES.WorkloadProcess.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(9, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WorkloadProcessGuid), TABLES.WorkloadProcess.WorkloadProcessGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WeightMultiplier), TABLES.WorkloadProcess.WeightMultiplier);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.AssignedDate), TABLES.WorkloadProcess.AssignedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.UnAssignedDate), TABLES.WorkloadProcess.UnAssignedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.DivisionCode), TABLES.WorkloadProcess.DivisionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.RecordStatusCode), TABLES.WorkloadProcess.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WorkloadCode), TABLES.WorkloadProcess.WorkloadCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.VbecsProcessId), TABLES.WorkloadProcess.VbecsProcessId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.WorkloadProcess.WorkloadProcedure), TABLES.WorkloadProcess.WorkloadProcedure);
		}


    }
}
#endif
